// Evaluate the block below to start the mapping MIDI -> OSC.
var on, off, cc;
var osc;


// Send OSC messages to Hydra
//var hydra = NetAddr.new("127.0.0.1", 3333);
//OSCFunc({ |msg, time, tidalAddr|
//	var latency = time - Main.elapsedTime;
//		msg = msg ++ ["time", time, "latency", latency];
//			msg.postln;
//				hydra.sendBundle(latency, msg)
//}, '/play2').fix;


osc = NetAddr.new("127.0.0.1", 6010);

MIDIClient.init;
MIDIIn.connectAll;

// Initial: sends velocity on note's channel
// on = MIDIFunc.noteOn({ |val, num, chan, src|
// 	osc.sendMsg("/ctrl", num.asString, val/127);
// });

on = MIDIFunc.noteOn({ |val, num, chan, src|
	// it will be passed the arguments val, num, chan, and src, corresponding to the message value (e.g. velocity, control value, etc.)
	osc.sendMsg("/ctrl", "note", (num - 60));
});

off = MIDIFunc.noteOff({ |val, num, chan, src|
	osc.sendMsg("/ctrl", "note", 0);
});

cc = MIDIFunc.cc({ |val, num, chan, src|
	osc.sendMsg("/ctrl", num.asString, val/127);
});

if (~stopMidiToOsc != nil, {
	~stopMidiToOsc.value;
});

~stopMidiToOsc = {
	on.free;
	off.free;
	cc.free;
};

// Evaluate the line below to stop it.
// ~stopMidiToOsc.value;

// MIDI OUT
//~midiOut = MIDIOut.newByName("iO4", "iO4 iO4"); // Alesis iO4
//~midiOut = MIDIOut.newByName("HAPAX", "HAPAX MIDI 1");


/*
This is an example startup file. You can load it from your startup file
(to be found in Platform.userAppSupportDir +/+ "startup.scd")
*/


(
// configure the sound server: here you could add hardware specific options
// see http://doc.sccode.org/Classes/ServerOptions.html
// Increased from 1024 * 256
s.options.numBuffers = 1024 * 256; // increase this if you need to load more samples
// Increased from 8192 * 32
s.options.memSize = 8192 * 32; // increase this if you get "alloc failed" messages
s.options.numWireBufs = 128; // increase if "exceeded number of wire buffer" messages
s.options.maxNodes = 1024 * 32; // increase this if you are getting drop outs and the message "too many nodes"
s.options.numOutputBusChannels = 12; // set this to your hardware output channel size, if necessary
s.options.numOutputBusChannels = 24; // MULTICHANNEL SETUP
s.options.numInputBusChannels = 2; // set this to your hardware output channel size, if necessary
// boot the server and start SuperDirt
s.waitForBoot {
	~dirt = SuperDirt(2, s); // two output channels, increase if you want to pan across more channels
	~dirt.doNotReadYet = true; // Lazy-loading https://club.tidalcycles.org/t/superdirt-lazy-samples-loading/3148
	//~dirt.loadSoundFiles;   // load samples (path containing a wildcard can be passed in)
	// for example: ~dirt.loadSoundFiles("/Users/myUserName/Dirt/samples/*");
	~dirt.loadSoundFiles("/home/pln/.local/share/SuperCollider/downloaded-quarks/Dirt-Samples/*");
	~dirt.loadSoundFiles("/home/pln/Work/Sound/Samples/extra/*");

	// DRUM MACHINES
  ~drumMachinesDir = PathName.new("/home/pln/Work/Sound/Samples/tidal-drum-machines/machines");
  ~machines = ~drumMachinesDir.folders; //All drum machines
  //*~machines = ['Linn9000','RolandTR909']; //Selected drum machines


	(
		~machines.do({
			arg machine;
			var folders = machine.folders;
//      postln("Loading machine: "++machine.folderName);
			folders.do({
				arg folder;
				~dirt.loadSoundFiles(folder.fullPath,namingFunction: { |x| x.basename.replace("-","")});
			});
		});
	);

	// s.sync; // optionally: wait for samples to be read
	//~dirt.start(57120, 0 ! 12);   // start listening on port 57120, create two busses each sending audio to channel 0
	~dirt.start(57120, [0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24]);   // start listening on port 57120, MULTICHANNEL - ALSO UPDATE NUMOUTPUT

	//~dirt.soundLibrary.addMIDI(\midi, ~midiOut); // Connect `midi` synth to iO4

	//~looper = TidalLooper(~dirt); // Start TidalLooper on top :)
	// ~looper.linput = 1;

	// optional, needed for convenient access from sclang:
	(
		~d1 = ~dirt.orbits[0]; ~d2 = ~dirt.orbits[1]; ~d3 = ~dirt.orbits[2];
		~d4 = ~dirt.orbits[3]; ~d5 = ~dirt.orbits[4]; ~d6 = ~dirt.orbits[5];
		~d7 = ~dirt.orbits[6]; ~d8 = ~dirt.orbits[7]; ~d9 = ~dirt.orbits[8];
		~d10 = ~dirt.orbits[9]; ~d11 = ~dirt.orbits[10]; ~d12 = ~dirt.orbits[11];
	);

  // Setup SCLOrK Synths (installed via Quark)
  SCLOrkSynths.load;

	// Setup Mutable synths
	// Verb as a global effect: https://club.tidalcycles.org/t/mutable-instruments-ugens/2730/22
//	(1..SuperDirt.maxSampleNumChannels).do { |numChannels|
//		SynthDef("global_mi_verb" ++ numChannels, { |dryBus, effectBus, verbwet=0, verbtime=0, verbdamp=0, verbhp=0, verbfreeze=0, verbdiff=0, verbgain=0|
//			var signal = In.ar(dryBus, ~dirt.numChannels);
//			signal = MiVerb.ar(signal, verbwet, verbtime, verbdamp, verbhp, verbfreeze, verbdiff);
//			Out.ar(effectBus, signal * verbgain)
//		}, [\ir, \ir]).add;
//	};

// 	~dirt.orbits.do { |x|
//		// var clouds = GlobalDirtEffect(\global_mi_clouds, [\cloudspitch, \cloudspos, \cloudssize, \cloudsdens, \cloudstex, \cloudswet, \cloudsgain, \cloudsspread, \cloudsrvb, \cloudsfb, \cloudsfreeze, \cloudsmode, \cloudslofi]);
//		var verb = GlobalDirtEffect(\global_mi_verb, [\verbwet, \verbtime, \verbdamp, \verbhp, \verbfreeze, \verbdiff, \verbgain]);
//		x.globalEffects = ~dirt.orbits[0].globalEffects.addFirst(verb);
//		x.initNodeTree;

//	//	x.set(\fadeTime, 0.01); // What was that for again? :think:
//	};
};

s.volume = 1;
s.latency = 0.3; // increase this if you get "late" messages
);
