/**
 * Launcher for ParVaguesViz
 */

void setup() {
  size(400, 300);
  background(0);
  fill(255);
  textAlign(CENTER, CENTER);
  textSize(16);
  text("ParVaguesViz Launcher\nPress any key to launch.", width/2, height/2);
  
  println("Launcher ready. Press any key to start ParVaguesViz...");
}

void draw() {
  // Empty draw loop
}

void keyPressed() {
  background(0);
  text("Launching...", width/2, height/2);
  
  try {
    // Get the path to the main sketch
    String mainSketchPath = sketchPath(".."); 
    println("Main sketch path: " + mainSketchPath);
    
    // Launch the main sketch with its full path
    String[] args = new String[] { 
      mainSketchPath + "/ParVaguesViz.pde"
    };
    
    // Use Java's ProcessBuilder to launch the main sketch
    ProcessBuilder pb = new ProcessBuilder("processing", args[0]);
    pb.directory(new File(mainSketchPath));
    pb.inheritIO(); // Forward output to our console
    Process p = pb.start();
    
    background(0, 100, 0);
    text("ParVaguesViz launched!\nYou can close this window.", width/2, height/2);
  } 
  catch (Exception e) {
    background(100, 0, 0);
    text("Error launching sketch.", width/2, height/2);
    println("Error: " + e.getMessage());
    e.printStackTrace();
  }
}
