// Le 5 mars 1999
// Galaxie NGC 1512
// Le noyau de la galaxie spirale barrée NGC 1512 est unique en raison de son étonnant cercle d'amas d'étoiles naissants, d'une largeur de 2 400 années-lumière, appelé anneau de flambées d'étoiles « circumnucléaire ». 
// Les flambées d'étoiles sont des épisodes de formation stellaire vigoureuse.

s0.initImage("https://imagine.gsfc.nasa.gov/hst_bday/images/march-5-2019-galaxy-ngc-1512.jpg")

src(s0)
  .out(o0)
src(o0)
  .scale(() => 1.2 + 0.4 * Math.sin(time/12))
//   .scroll(0.01)
  .blend(src(o2).scale(0.999))
  .out(o1)
src(o1)
  .add(src(o1).scale(0.95), () => 0.1 + 0.4 * Math.sin(time / 1975))
  .out(o2)
src(o2)
	.modulate(src(s0)
         .scale(() => 1 + 0.4 * Math.sin(time/1975))
         .rotate(() => time/(75) % 360)
         ,() => 0.2 + 0.4 * Math.sin(time / 13))
    .add(s0, 0.3)
	.brightness(-0.3)
    .contrast(1.3)
  	.out(o3)
render(o3)
