// Full M00N
// Based on 'full moon photography' By Mike Petrucci
// https://unsplash.com/photos/uIf6H1or1nE

s0.initImage("https://git.plnech.fr/pln/Hydra/raw/master/biarritz/fullmoon.avif")

src(s0)
.scale(0.9, 1.05)
.contrast(1.4)
.out(o0)

src(o0)
  .out(o1)

src(o1)
  .blend( // Dark Night
    src(o1)
    .sub(
      noise(() => 10 + 80 * Math.sin(time / 1000))
      .luma(() => Math.sin(time / 23))
      .invert())
      ,
    () => 0.8 + 0.65 * Math.sin(time / 42)
  )
  .out(o2)

src(o2)
  .modulateRotate(voronoi(10, 0.05).rotate(() => time /120 % 360)
    .mask(shape(30).scale(
      () => 1.75 + 0.1 * Math.sin(time / 40),
      () => 0.9 + 0.1 * Math.sin(time / 13)
    ))
  )
  .scale(1.3)
  .out(o3)

render(o3)
