// On February 18 in 2014
// Herbig-Haro 24
// A partially obscured, newborn star near the center of this image is shooting twin jets into the surrounding gas and dust.
// The shocks from the collision light up patches of nebulosity collectively called Herbig-Haro 24.
s0.initImage("https://git.plnech.fr/pln/Hydra/raw/master/StarryNights/img/february-18.jpg")
// Source celeste: Herbig-Haro
src(s0)
  // .scale(() => 1 + 0.025 * Math.sin(time / 13.12))
  // .scale(() => 1.15 + 0.25 * Math.sin(time / 18.0264))
  .contrast(1.2).brightness(-0.05)
  .out(o0)
// Transformation: modulation électrique
src(o0)
  .modulate(src(o0)
    .scale(() => 0.9 + 0.1 * Math.sin(time/19.64))
  )
  .out(o1)
// Assistant Executif: Le Cercle
shape(64).scale(0.8,0.6).scale(() => 1.5 + 0.5 * Math.sin(time / 1802))
.scale(() => 0.9 + 0.85 * Math.sin(time / 64.1802))
.out(o2)
// Forme finale: sphère d'influence
src(o1)
  .modulate(src(o2))
  .add(src(o3).contrast(1.993).mask(o2), 0.2)
  .add(noise(199,0.02)
    .thresh(() => 0.93 + 0.1 * Math.sin(time / 64.1802))
    .scroll(0, () => -time/1964.0218)
    .mask(src(o2).invert())
  )
.out(o3)
render(o3)
