#!/bin/bash

# Create the image directory if it doesn't exist
mkdir -p img

# Base URL for the images
BASE_URL="https://imagine.gsfc.nasa.gov/hst_bday/images/"

# Check if data.csv exists
if [ ! -f "data.csv" ]; then
    echo "Error: data.csv file not found!"
    exit 1
fi

# Counter for downloaded images
count=0
total=$(wc -l < data.csv)

echo "Starting download of $total Hubble birthday images..."

# Read each line of the CSV file
# Skip the first line if it's a header
skip_first=true

while IFS=, read -r date image_filename title description more_info year; do
    # Skip header if needed
    if $skip_first; then
        skip_first=false
        continue
    fi
    
    # Extract the image filename (remove any quotes)
    image_filename=$(echo "$image_filename" | tr -d '"')
    
    # Construct the full URL
    url="${BASE_URL}${image_filename}"
    
    # Download the image with wget, showing progress
    echo "[$((count+1))/$total] Downloading: $image_filename"
    wget -q --show-progress -O "img/$image_filename" "$url"
    
    # Check if download was successful
    if [ $? -eq 0 ]; then
        count=$((count+1))
        echo "Downloaded: img/$image_filename"
    else
        echo "Failed to download: $url"
    fi
    
    # Small delay to be nice to the server
    sleep 0.5
    
done < data.csv

echo "Download complete! Successfully downloaded $count images."
