// On July 1 in 1993
// Comet Shoemaker-Levy 9 Fragments
// This image captures the brightest "nucleus" in a string of approximately 20
// that comprised the broken-up comet Shoemaker-Levy 9.
// The image reveals that the bright segment is actually a group of at least four separate pieces.
// Created by Paul-Louis
// For Kyu and Ben
// License CC-BY-NC-SA
// Framework Hydra.js by Olivia Jack - hydra.ojack.xyz
// s0.initImage("https://imagine.gsfc.nasa.gov/hst_bday/images/july-1-2019-comet-shoemaker-levy-9-fragments.jpg")
s0.initImage("https://git.plnech.fr/pln/Hydra/raw/d36c64fc40b803849a26fc63c1a3191b12eb9955/StarryNights/img/july1.jpeg")
src(s0)
.out(o0)

src(o0)
  .rotate(() => (time/(12) % 360))
  .out(o1)

src(o1)
.scale(0.5)
// .scroll(() => 0.2 + 0.05 * Math.sin(time / 18))
.out(o2)

src(o2)
.scale(() => 3.6 + 1.3 * Math.sin(time/ 3))
.add(src(o2).mask(shape(30).scale(() => 2 + 0.5 * Math.sin(time / 20)),0.1).brightness(0.2))
// .colorama(0.1)
.blend(src(o1).scale(4).thresh(() => 1 + 0.2 * Math.sin(time / (32 + 67))), 0.2)
.saturate(1)
.contrast(0.7)
.colorama(() => 0.9 + 0.05 * Math.sin(time / 8))
.brightness(-0.4)
.blend(o0,0.5)
.out(o3)

// render()
render(o3)
