// By PLN, for Did
// On February 24 in 2009
// Saturn and Moons
// In this image, four moons of Saturn are passing in front of the giant planet.
// The large, orange moon Titan casts a large shadow on the northern pole. Smaller moons Mimas, Dione and Enceladus appear as white dots.
s0.initImage("https://git.plnech.fr/pln/Hydra/raw/master/StarryNights/img/february-24-2019-saturn-and-moons.jpg")
// Source celeste: Saturne
src(s0)
  .scale(() => 1 + 0.025 * Math.sin(time / 13.12))
  .scale(() => 1.15 + 0.25 * Math.sin(time / 2402.57))
  .contrast(1.32).brightness(-0.1)
  .out(o0)
// Oeuvre au noir: soustraction en rotation
src(o0)
  .sub(src(o2).rotate(() => time/199.3 % 360).scale([0.999,1.001]))
  .out(o1)
// Oeuvre au blanc: filtre lumineux
src(o0)
  .add(src(o1)
    .rotate(() => -(time/57.0224) % 220)
    .luma(() => 0.5 + 0.8 * Math.sin(time/19.93))
    .mask(voronoi(12,0.2))
    .scale(0.25))
  .out(o2)
//Oeuvre au jaune: Masque geometrique
src(o1)
  .blend(src(o1),() => 0.8 + 0.6 * Math.sin(time/(1312)))
  .blend(o2,() => 0.4 + 0.8 * Math.sin(time / 10))
  // Oeuvre au rouge: Etoiles solaires
  .add(noise(93,0.01)
    .scroll(() => time/195.7)
    .mask(shape(30).scale(1.31, 0.78).invert())
    .thresh(0.93))
  .out(o3)
render(o3)
