// By PLN, for Caoimhe's Significant Other <3
// On March 4 in 2003
// Galaxy Fornax A
// The dust lanes and star clusters of this giant elliptical galaxy,
// known as Fornax A, give evidence that the galaxy formed from a past merger
// of two gas-rich galaxies. It is also one of the strongest sources
// of radio emission in the sky.

// s0.initImage("/home/pln/Work/Hydra/StarryNights/img/march-4-2019-galaxy-fornax-a.jpg")
s0.initImage("https://git.plnech.fr/pln/Hydra/raw/fadf3c87cb23d0e933e30962f6e2d530e2ab483a/StarryNights/img/march-4-2019-galaxy-fornax-a.jpg")
// Source celeste: Fornax A
src(s0)
  .scale(() => 1 - 0.05 * Math.sin(time / 4))
  .scale(() => 1.35 + 0.25 * Math.sin(time / 34))
  .brightness(-0.2)
  .contrast(0.82)
  .blend(src(o0).scale(() => 1 + 0.05 * Math.sin(time / 10)), 0.65)
  .out(o0)
src(o0)
  .mult(src(o2)
    .scale(2)
    .rotate(() => time/43 % 360)
    .scale([0.999,1.001]),
    () => 0.7 - 0.6 * Math.sin(time/20)
  )
  .out(o1)
// Oeuvre au blanc: filtre lumineux
src(o0)
  .add(src(o1)
    .rotate(() => -(time/57.0224) % 220)
    .luma(() => 0.5 + 0.4 * Math.sin(time/1.3))
    .mask(noise(120,0.2).luma(0.7))
    .scale(0.25))
  .out(o2)
//Oeuvre au jaune: Masque geometrique
src(o1)
  .blend(src(o1),() => 0.8 + 0.6 * Math.sin(time/(1312)))
  .blend(o2,() => 0.4 + 0.8 * Math.sin(time / 45))
  // Oeuvre au rouge: Etoiles solaires
  .add(noise(93,0.01)
    .scroll(() => time/195.7)
    .mask(shape(30).scale(1.31, 0.78).invert())
    .thresh(0.93))
  .out(o3)
render(o3)
