// ◬◬◬◬◬◬◬◬◬◬◬◬◬◬◬◬◬
// ◬◬◬ Adenora's Triangulum ◬◬◬
// ◬◬◬◬◬◬◬◬◬◬◬◬◬◬◬◬◬
//
// Merci pour l'accueil <3
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
// "This mosaic captures the nearby Triangulum galaxy.
// Striking areas of star birth
// glow bright blue throughout the galaxy,
// particularly in beautiful nebulas of hot gas
// like star-forming region NGC 604 in the upper left."
//
//
//
//
//
//
// Remixing Olivia Jack's example_15
// licensed with CC BY-NC-SA 4.0 https://creativecommons.org/licenses/by-nc-sa/4.0/
//
s0.initImage("https://git.plnech.fr/pln/Hydra/raw/master/StarryNights/img/august-15-2019-triangulum-galaxy.png")
s1.initImage("https://git.plnech.fr/pln/Hydra/raw/master/StarryNights/img/adenora.png")

src(s0).brightness(0.1).contrast(1.2).scroll(
  () => 0.03 + 0.01 * Math.sin(time/2),
  () => 0.1 + 0.04 * Math.sin(time/7)
).scale(2).out(o0)
osc(() => (time/10 % 100), 0.01, 1.4)
	.rotate(0, 0.1)
	.mult(osc(10, 0.0005).modulate(osc(10, .01).rotate(0, -0.1), 1))
// 	.color(2.83,0.91,0.39)
  .out(o1)
src(o0)
  .mult(o1)
  .out(o2)
src(o2)
  .add(noise(100,0.2).thresh(0.9))
  .add(src(o2).scale(0.5).mask(src(s1).scale(0.95)))
  .out(o3)
render(o3)
