// Based on NASA LSPN-1725 (Comet P/Halley as taken March 8, 1986 by W. Liller, Easter Island)
s0.initImage("file:///home/pln/Work/Hydra/StarryNights/img/ShoemakerLevy9.png");
src(s0).out(o0)

shape(93)
  .modulateRotate(noise(0.26,0.1))
  .blend(noise(0.6,0.001),0.36)
  .blend(noise(10,0.01).mask(shape(30).scale(0.95)))
  .blend(voronoi(90,0.008).mask(shape(30).scale(0.85)),0.1)
  .add(voronoi(30,0.001).mask(shape(30).scale(0.75)),0.4)
  .blend(voronoi(0.2,0.001).mask(shape(30).scale(0.55)),0.2)
  .color(216/256,149/256,97/256)
  // .scale(() => 0.5 + 3 * Math.sin(time/60))
.out(o1)

src(o0)
  .scale(0.8)
  .scrollY(-0.125)
  .rotate(-120)
  .blend(src(o3).scale(0.9).brightness(0.02))
  .add( // Add Jupiter
    src(o1)
    .mask(src(o1).thresh(0.125)) // Adjust brightness
    .scale(0.95)
  )
.layer(o1)
.out(o2)

src(o2)
.modulate(o2,() => Math.sin(time/1000))
.scale(() => 1.4)
.out(o3)
render(o3)
