// On April 21 in 2014
// This image of Jupiter was taken by the OPAL Program
// (Outer Planet Atmospheres Legacy), a long-term project that uses Hubble
// to capture global maps of the outer planets every year.
// The Great Red Spot appears in the lower right.

s0.initImage("https://imagine.gsfc.nasa.gov/hst_bday/images/april-21-2019-jupiter.jpg")

periodMask = 21
periodScale = 040
periodVoronoiScale = 30
periodVoronoiRot = 420

src(s0)
  .scale(() => 1 + 0.05 * Math.sin(time / periodScale))
  .out(o0)

src(s0).luma(0.57, 0.2).invert().out(o1)

src(o0)
  .mask(src(s0)
    .modulateScale(voronoi(20, () => 0.03 + 0.02 * Math.sin(time / periodVoronoiScale)))
    .rotate(() => time / periodVoronoiRot % 360))
  .out(o2)


src(o2).blend(
  src(o2)
    .colorama(0.01)
    .modulateScale(src(o1).scale(20))
    // .contrast(-0.3)
    .mask(shape(30).scale(3)), () => 0.2 + 0.725 * Math.sin(time / periodMask)
)
.out(o3)

render(o3)
