// Based on NASA LSPN-1725 (Comet P/Halley as taken March 8, 1986 by W. Liller, Easter Island)
s0.initImage("https://git.plnech.fr/pln/Hydra/raw/master/StarryNights/img/halley.png");
src(s0).out(o0)
src(o0)
  .modulate(src(o0),() => Math.sin(time/100) / 10)
.out(o1)
src(o1)
  .modulateScale(osc(1,0.4),0.05)
  .blend(noise(100,0.92).colorama(),0.07)
.out(o2)
src(o2)
  .blend(src(o2).thresh(), () => 0.5 + 0.125 * Math.sin(time / 100 % 180))
  .scrollX(-0.05)
  // .scrollY(-0.1)
  .scale(1.08)
.out(o3)
render(o3)
