// On July 12, 2022
// NASA’s James Webb Space Telescope has produced the deepest and sharpest infrared image of the distant universe to date.
// Known as Webb’s First Deep Field,
// this image of galaxy cluster SMACS 0723 is overflowing with detail
// https://www.nasa.gov/image-feature/goddard/2022/nasa-s-webb-delivers-deepest-infrared-image-of-universe-yet

s0.initImage("file:///home/pln/Work/Hydra/StarryNights/img/Webb_deepest_yet.png")

src(s0)
  // .contrast(() => 1 + 0.28 * Math.sin(time/42))
  // .brightness(() => 0 + 0.5 * Math.sin(time/42))
  .out(o0)

src(s0)
  .luma(0.57, 0.2)
  .invert()
  .out(o1)

src(o0)
  .modulateScale(osc(1.2,0.02))
  .out(o2)


src(o2)
.scrollX(() => 0.1 * Math.sin(time / 200))
.scrollY(() => - 0.2 * Math.sin(time / 193))
.scale(1.5)
.blend(
  src(o2)
    .mask(
      src(o1)
      .scale(() => 1 + 0.5 * Math.sin(time / 100))
      .modulate(noise(() => 0 + Math.sin(time / 23)))
      .rotate(() => time / 10 % 360)
    )
    .colorama(() => 0.1 * Math.cos(time / 50))
    ,   () => 0.2 + 0.09 * Math.sin(time/4)
)
.brightness(-0.15)
.out(o3)

render(o3)
