// On October 15 in 2003
// Supernova Remnant E0102
//
// In a nearby galaxy called the Small Magellanic Cloud,
// a massive star exploded as a supernova
// and dissipated its interior into a spectacular display of colorful filaments.
// The supernova remnant, known as E0102, is the greenish-blue field of debris just below center.

periodeTelescope = 42
periodeModulation = 100
periodeModulationInterne = 1000
periodeModulationExterne = 200000
periodeBlend = 5
periodeBlendModulate = 100
//
// // DEBUG
// periodeTelescope = 10
// periodeModulation = 10
// periodeModulationInterne = 100
// periodeModulationExterne = 20000
// periodeBlend = 5
// periodeBlendModulate = 100

s0.initImage("https://git.plnech.fr/pln/Hydra/raw/850a3aa96138ec40b71b5e57f328dba9c8f872f5/StarryNights/img/october-15-2019-supernova.jpg")
src(s0)
.contrast(() => 1.1 + 0.2 * Math.cos(time / 100))
.out(o0)

noise(() => 2 + 0.15 * (time / 360),
  () => Math.cos(time) * 0.00002).out(o1)


src(o0).modulate(o1,
  () => (
    (time / periodeModulation) *
    Math.cos(time / periodeModulationInterne) *
    Math.sin(time / periodeModulationExterne) *
    1
  )
).out(o2)

src(o2)
.scale(() => 0.991 + 1.4 * Math.sin(time / periodeTelescope))
.modulate(src(o3), () => 0.04 * Math.sin(time / periodeBlendModulate))
.blend(src(o3), () => 0.15 + 0.85 * Math.sin(time / periodeBlend))
.out(o3)
render(o3)
