// Ariane13 par PLN
// À partir d'une photo prise le 13 avril 2019 par le téléscope Hubble de Abell 2261, une galaxie géante 10 fois plus grande que notre Voie Lactée.
// https://nech.pl/ariane13
// Original image credit: NASA; ESA; M. Postman, STScI; T. Lauer, NOAO, Tucson; CLASH team.

s0.initImage("/home/pln/Work/Hydra/StarryNights/img/april-13-2019-galaxy-cluster-abell-2261.jpg")
// s0.initImage("https://git.plnech.fr/pln/Hydra/raw/e8cd9c3651615342ee7af334fe21684585409941/StarryNights/img/april-13-2019-galaxy-cluster-abell-2261.jpg")
src(s0)
.brightness(0.13).contrast(1.72)
.out(o0)

periodeGravite = 13
periodeRotation = 13 * 04
periodeTelescope = 13 * 04 * 92
periodeTrousNoirs = 13 * 13 * 13 * 13

// DEBUG
// periodeGravite = 10
// periodeTrousNoirs = 20
// periodeRotation = 13
// periodeTelescope = 2


src(o0)
.blend(o0)
.blend(src(o1).scale(0.5,0.9)
  .contrast(1.05)
  .rotate(() => -time/13 % 360)
  , 0.35)
.out(o2)

src(o2)
  .modulate(o0,() => Math.sin(time/13)/10)
  .out(o1)

src(o1)
  .blend(o0, () => 0.25 + Math.sin(time / periodeTrousNoirs) * 1.5)
  .blend(src(o1).add(noise(100,0.1).thresh(0.9 + 0.05 * Math.sin(time))).scale(0.9), 0.32)
  .scale(() => 1.5 + Math.sin(time/periodeTelescope) * 0.6)
.out(o3)

render(o3)
