

// On March 30 in 1997
// Four Faces of Mars

// "Four sides of Mars are captured in these Hubble images, taken over the course of a day. Mars has rotated about ninety degrees between each view.
s0.initImage("https://imagine.gsfc.nasa.gov/hst_bday/images/march-30-2019-four-faces-of-mars.jpg")

src(s0)
.scale(() => 0.5 + 0.15 * Math.sin(time/20),1.35)
.hue([0,0.5,0.6,0.7].fast(1/8))
.out(o0)

src(o0)
.scale(() => 0.99 + 0.15 * Math.sin(time/40),0.59)
.out(o1)



src(o1)
.diff(src(o2).scale(0.99).thresh(() => 0.9 + 0.2 * Math.sin(time / 13)))
// .scale(() => 0.99 + 0.2 * Math.sin(time/9),0.65)
.out(o2)

src(o2)
// .scroll(() => 0 + 0.1 * Math.sin(time/4),0.65)
.rotate(() => Math.sin(time/100))
.blend(src(o3).scale(() => 1 + 0.15 * Math.sin(time / 130)))
.contrast(() => 1.5 + 0.4 * Math.sin(time/20))
.out(o3)

render(o3)
