// PixelBlur LIVE
// PLN - derived from [PixelScale by Marianne Teixido](https://github.com/MarianneTeixido)

a.setCutoff(2)
a.setBins(4)
a.setScale(6)
a.setSmooth(0.45)
a.show()

src(o0)
 .saturate(() => 0.91 + 0.0125 * a.fft[3])
 .scale(() => 0.99 + 0.005 * a.fft[0])
 .scrollX(0.01)
 .color(1.01,1.01,1.01)
 .hue(.02481)
 .blend(o1,() => 0.01 * Math.sin(time))
 .modulateHue(
   src(o1)
   .hue(.3)
   .posterize(-1)
   .contrast(.7)
   ,[0,0,8].fast(1/4))
  .layer(src(o1)
         .luma()
        .mult(gradient(1)
               .saturate(.9)
        )
  )
  .out(o0)

noise(1, .2)
  .rotate(2,.5)
  .layer(src(o0)
  .rotate(() => 0.32 + 0.2 * a.fft[1])
  .scrollX(() => 0.8 + 0.2 * Math.sin(t/4))
  .scrollY(() => 2 * Math.sin(t/8))
  )
  .out(o1)

src(o1)
  .scrollX(0.6)
  // .scale(2)
  .out(o2)

src(o2)
  .contrast(() => 0.5 * a.fft(2))
  // .scrollX(() => Math.cos(time * 0.6))
  // .scale(0.8)
  .out(o3)

render(o3)
