// La RED WAVE
// licensed with CC BY-NC-SA 4.0 https://creativecommons.org/licenses/by-nc-sa/4.0/
shape(4,0.5).out(o0)
osc(23,0.01,1).modulate(noise(2,0.1),0.5).out(o1)
src(o1).modulate(src(o2).add(solid(1,1),-0.5),0.01).blend(o0,0.01).out(o2)



solid(0.8,-0.5,-0.5).blend(o2)
  // .hue(() => 0.3 + 0.1 * a.fft[3])
  // .brightness(+0.1)
  .scale(() => 1.82 + 8.75 * a.fft[0])
  .rotate(() => 2 + (time/20 % 10) * a.fft[2])
  .modulate(osc(20,() => 0.1 + 0.0002 * a.fft[3]).rotate(() => time/13 % 2 + 2.85))
  .pixelate(() => (768 - 1024 * a.fft[1]), () => 1024 - 768 * a.fft[3])
  .modulateScale(voronoi(10,0.09).luma(() => Math.sin(time / 113)))
  .scrollX(() => Math.sin(time / 23))
  .modulate(osc(() => 20 + 200 * a.fft[3],0.02), 0.1)
  // .kaleid(() => 8 + 2 * a.fft[2] - 4 * a.fft[3])
  .modulate(src(o3).scale(0.95))
  .scale(() => 0.6 + 0.4 * a.fft[0])
  .luma(() => 0.43 - 0.4 * a.fft[2])
  .out(o3)

a.show()
a.setSmooth(0.125)

render(o3)
