// From a picture of Galaxy Nasa 724203
// Private share: https://nech.pl/nights-galactic
s0.initImage("file:///home/pln/Work/Hydra/StarryNights/img/724203.jpg")
src(s0).out()

src(o0)
.blend(o0)
.blend(src(o1).scale(0.5,0.9).rotate(() => Math.sin(time/900) * 360), 0.25)
.out(o2)

src(o2)
  .modulate(o0,() => Math.sin(time/2) % 2)
  .scale(() => Math.sine(time) * 9 + 0.9)
  .out(o1)

  render(o3)

src(o1)
  .blend(o0)
  // .blend(o1,() => a.fft[3])
  .brightness(0.23).contrast(1.4)
  .luma()
  .scale(() => 0.2625 + (a.fft[0] - (0.2 * time % 36)) * 0.6 + 0.62)
  .rotate(() => (time/14) % 360)
  .scale(() =>  0.5 + 1.4 * Math.sin(time))
  .brightness(-0.5)
  .luma(0.5)
.out(o3)

render(o3)

a.show()
